/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.ConfigException;
import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemCartridgeComposite;
import frc.emul.config.data.CfgItemCartridgeStandalone;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemGameContainer;
import frc.emul.config.handler.CLHGameHacks;
import frc.emul.config.handler.CLHGameInfo;
import frc.emul.config.handler.CLHGameOverlay;
import frc.emul.config.handler.CLHGamePersistence;
import frc.emul.config.handler.CLHGameRam;
import frc.emul.config.handler.CLHGameRoms;
import frc.emul.config.handler.CLHGameShininess;
import frc.emul.config.handler.CLHGames;
import frc.emul.config.handler.CLHPeripheral;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import java.util.List;
import org.xml.sax.Attributes;

public class CLHGame
extends ConfigLoaderHandler {
    CfgItemGame game;
    private String gameID;
    private String gameName;

    public CLHGame(CLHGames cLHGames) {
        super(cLHGames);
    }

    public void pushed(Attributes attributes) {
        List<CfgItemGameContainer> list = this.getConfig().games;
        this.game = new CfgItemGame();
        this.gameName = CLHGame.getAttribute(attributes, "name", "Game #" + (list.size() + 1));
        this.gameID = CLHGame.makeUniqueID(CLHGame.getAttribute(attributes, "id", "GAME"), list);
        int n = RESERVED_GAMEIDS.length;
        while (n-- > 0) {
            if (!RESERVED_GAMEIDS[n].equals(this.gameID)) continue;
            this.gameID = CLHGame.makeUniqueID(this.gameID, list);
            break;
        }
    }

    public void poped() {
        if (this.game != null && this.game.cartridge != null) {
            if (CfgItemCartridge.EMPTY == this.game.cartridge) {
                this.game.cartridge = CfgItemCartridge.newEmptyCartridge(this.gameID, this.gameName);
            }
        } else {
            throw new ConfigException("Invalid cartridge definition for game [" + (this.game == null ? this.gameID : this.game.getID()) + "]");
        }
        ((CLHGames)this.getParent()).addGame(this.game);
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        if (string.equals("roms")) {
            return new CLHGameRoms(this);
        }
        if (string.equals("ram")) {
            return new CLHGameRam(this);
        }
        if (string.equals("requirement")) {
            return new CLHPeripheral(this);
        }
        if (string.equals("overlay")) {
            return new CLHGameOverlay(this);
        }
        if (string.equals("persistence")) {
            return new CLHGamePersistence(this);
        }
        if (string.equals("shininess")) {
            return new CLHGameShininess(this);
        }
        if (string.equals("hack")) {
            return new CLHGameHacks(this);
        }
        if (string.equals("info")) {
            return new CLHGameInfo(this);
        }
        return super.getChildHandler(string, attributes);
    }

    CfgItemCartridgeStandalone attachNewStandaloneCartridge() {
        this.checkCartridgeCreation();
        CfgItemCartridgeStandalone cfgItemCartridgeStandalone = new CfgItemCartridgeStandalone(this.gameID, this.gameName);
        this.game.cartridge = cfgItemCartridgeStandalone;
        return cfgItemCartridgeStandalone;
    }

    CfgItemCartridgeComposite attachNewCompositeCartridge() {
        this.checkCartridgeCreation();
        CfgItemCartridgeComposite cfgItemCartridgeComposite = new CfgItemCartridgeComposite(this.gameID, this.gameName);
        this.game.cartridge = cfgItemCartridgeComposite;
        return cfgItemCartridgeComposite;
    }

    String getGameID() {
        return this.gameID;
    }

    boolean isCartridgeCreated() {
        return this.game.cartridge != null && this.game.cartridge != CfgItemCartridge.EMPTY;
    }

    private void checkCartridgeCreation() {
        if (this.isCartridgeCreated()) {
            throw new IllegalStateException("The cartridge for the for game [" + this.getGameID() + "] has already been created!");
        }
    }
}

